/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
********************************************************************************
* FileName: U4ATypes.h                                                         *
*                                                                              *
* Author                     Date           Version                            *
*------------------------------------------------------------------------------*
* Carlos Grossy              21/03/2007       1.0                              *
*******************************************************************************/

#ifndef _U4ATYPES_H_
#define _U4ATYPES_H_

using namespace std;
#include <cstring>
#include <cstdio>
#include <cstdlib>

#ifdef _BUILDING_USB4ALLAPI
	#define _IMPEXP_USB4ALLAPI __declspec(dllexport)
#else
    #define _IMPEXP_USB4ALLAPI __declspec(dllimport)
#endif

#ifdef _DRIVER_MICROCHIP
    #define _DRIVER 1
#endif

#ifdef _DRIVER_LIBUSB
    #define _DRIVER 2
#endif

#ifdef _DRIVER_LIBUSBWIN32
    #define _DRIVER 3
#endif

#ifdef _DRIVER_CUSTOM
    #define _DRIVER 4
#endif

#define MAX_LEN_DEV_NAME 8 // usarlo para controlar.
#define MAX_HP_DATA_SIZE 253 // obsoleto
#define MAX_CP_DATA_SIZE 252 // obsoleto
#define MAX_BOARDS 16
#define DELAYSEND 2000
#define DELAYRECV 3000
#define U4ADSC  1
#define U4AHND  0
#define HNDERROR 0xFF
#define MAX_LEN_MSG 64
#define HEAD_HP_SIZE 3

typedef enum {NOTHING=-1,OPEN,CLOSE,MESSAGE,LOAD,UNLOAD,GETMAP} command;
typedef enum {SEND=0,CONFIG,SEND1,SEND2,SEND3,REALTIME} operation;

_IMPEXP_USB4ALLAPI typedef unsigned int handler;
_IMPEXP_USB4ALLAPI typedef char devname[8];
_IMPEXP_USB4ALLAPI typedef char data [253];
_IMPEXP_USB4ALLAPI typedef int * ptrfunc;

#endif
